import discord

from discord.ext import commands

import json

with open("config.json", "r") as f:

    config = json.load(f)

LOG_CHANNEL_ID = config["LOG_CHANNEL_ID"]

class Logs(commands.Cog):

    def __init__(self, bot):

        self.bot = bot

    async def send_log(self, guild, embed):

        log_channel = guild.get_channel(LOG_CHANNEL_ID)

        if log_channel:

            await log_channel.send(embed=embed)

    @commands.Cog.listener()

    async def on_member_join(self, member):

        embed = discord.Embed(title="✅ Nouveau membre", description=f"{member.mention} a rejoint le serveur.", color=discord.Color.green())

        await self.send_log(member.guild, embed)

    @commands.Cog.listener()

    async def on_member_remove(self, member):

        embed = discord.Embed(title="❌ Membre parti", description=f"{member} a quitté le serveur.", color=discord.Color.red())

        await self.send_log(member.guild, embed)

    @commands.Cog.listener()

    async def on_message_delete(self, message):

        if message.author.bot:

            return

        embed = discord.Embed(title="🗑️ Message supprimé", color=discord.Color.orange())

        embed.add_field(name="Auteur", value=message.author.mention, inline=True)

        embed.add_field(name="Salon", value=message.channel.mention, inline=True)

        embed.add_field(name="Contenu", value=message.content or "*Aucun contenu*", inline=False)

        await self.send_log(message.guild, embed)

    @commands.Cog.listener()

    async def on_message_edit(self, before, after):

        if before.author.bot or before.content == after.content:

            return

        embed = discord.Embed(title="✏️ Message modifié", color=discord.Color.blurple())

        embed.add_field(name="Auteur", value=before.author.mention, inline=True)

        embed.add_field(name="Salon", value=before.channel.mention, inline=True)

        embed.add_field(name="Avant", value=before.content or "*Vide*", inline=False)

        embed.add_field(name="Après", value=after.content or "*Vide*", inline=False)

        await self.send_log(before.guild, embed)

    @commands.Cog.listener()

    async def on_member_ban(self, guild, user):

        embed = discord.Embed(title="🔨 Membre banni", description=f"{user} a été banni.", color=discord.Color.dark_red())

        await self.send_log(guild, embed)

    @commands.Cog.listener()

    async def on_member_unban(self, guild, user):

        embed = discord.Embed(title="♻️ Membre débanni", description=f"{user} a été débanni.", color=discord.Color.green())

        await self.send_log(guild, embed)

async def setup(bot):

    await bot.add_cog(Logs(bot))